/*

  Christmas Music Disk - Sid Playbac Thread
  
  (c) 2004 The Gang

  Code by: Fred ( fred@thegang.nu )
  Music: Gouafhg & TheCheat 
  Graphics: MRK & Nisse
    
  http://www.thegang.nu

*/

#include <vcl.h>
#pragma hdrstop

#include "SidThread.h"
#pragma package(smart_init)

__fastcall SidPlayer::SidPlayer(bool CreateSuspended)
  : TThread(CreateSuspended), tune(NULL)
{
   rs = NULL;
   device = NULL;

   stopped=true;
   stopping=true;
   start=false;
   changeme = false;
   SongName = NULL;
   PlayTime = 0;

   FreeOnTerminate = false;
}

__fastcall SidPlayer::~SidPlayer()
{
  sid2_config_t pcfg = player.config();
  if (pcfg.sidEmulation!=NULL) delete pcfg.sidEmulation;
  if (device != NULL) delete device;
}

//---------------------------------------------------------------------------
void __fastcall SidPlayer::Execute()
{
  while (!Terminated) {

     while (!start) {
        Sleep(10);
        if (Terminated) return;
     }

     stopped=false;
     stopping=false;
     start=false;

     // set player config
     sid2_config_t pcfg = player.config();
     pcfg.frequency = 44100;
     pcfg.sampleFormat = SID2_LITTLE_SIGNED;
     pcfg.optimisation = 0;
     pcfg.precision = 16;
     pcfg.playback = sid2_mono;
     pcfg.forceDualSids = false;
     pcfg.sidModel = SID2_MODEL_CORRECT;
     pcfg.sidDefault = SID2_MOS6581;
     pcfg.clockSpeed = SID2_CLOCK_PAL;
     pcfg.clockDefault = SID2_CLOCK_PAL;

     // add ReSID sidbuilder
     if (pcfg.sidEmulation == NULL)
     {
        rs = new ReSIDBuilder("ReSID");
        rs->create(1);

        pcfg.sidEmulation = rs;
     }

     if (rs!=NULL) {
        rs->filter(true);
        rs->sampling(44100);
     }

     player.config(pcfg);

     HRSRC hRes = FindResource(NULL, SongName.c_str(), RT_RCDATA);

     BYTE *SIDData = (BYTE*)LoadResource(NULL, hRes);
     DWORD SIDSize = SizeofResource(NULL, hRes);

     if (!tune.read(SIDData, SIDSize))
        stopping=true;

     FreeResource(SIDData);

     tune.selectSong(0);
     player.load(&tune);
     #ifdef SID_PLAYONCE
        PlayTime = PlayTime * player.timebase();
     #endif

     if (device==NULL) device = new AudioDriver;
     cfg.frequency = pcfg.frequency;
     cfg.precision = pcfg.precision;
     cfg.channels  = 1; // Mono
     cfg.bufSize   = 0; // Recalculate
     if (pcfg.playback == sid2_stereo)
        cfg.channels = 2;
     device->open (cfg, NULL);
     void *buffer = device->buffer ();
     if (buffer==NULL) stopping=true;

     while (!stopping) {
        buffer = device->buffer ();
        uint_least32_t length = cfg.bufSize;

        player.play (buffer, length);
        device->write ();

        #ifdef SID_PLAYONCE
           uint_least32_t t = player.time();
           if (t>=PlayTime) changeme = true;
        #endif
     }

     player.stop();
     player.load(NULL);

     if (device!=NULL) {
        device->close();
     }
     stopped = true;
  }
}
//---------------------------------------------------------------------------

void SidPlayer::Stop()
{
  stopping=true;
}

bool SidPlayer::IsPlaying()
{
  return !stopped;
}

void SidPlayer::StartSong(char *songname, int playtime)
{
  SongName = AnsiString(songname);
  PlayTime = playtime;
  start=true;
  changeme = false;
}
