/*

  Christmas Music Disk - Main file
  
  (c) 2004 The Gang

  Code by: Fred ( fred@thegang.nu )
  Music: Gouafhg & TheCheat 
  Graphics: MRK & Nisse
    
  http://www.thegang.nu

  Uses:
    Borland C++ Builder 6 Professional
      http://www.borland.com
    Sidplay2 Borland C++ Builder version
      http://sidplay2.sf.net
    BASS Sound System
      http://www.un4seen.com
    LMD-Tools SE
      http://www.lmdtools.com

  Compile:
     1. Download BASS, extract it to a directory called bass in the MusicDisk directory.
     2. Run "implib BASSBCB.LIB bass.dll" to get an libfile compatible with BCB6.
     3. Check out sidplay2 from the CVS, look at http://sidplay2.sf.net on how to do that.
        You need the following modules: builders, libsidplay, libsidutils and sidplay
     4. Download resid and put it in the same directory as these modules.
     5. Take the MusicDisk directory and and put it in the directory where you put the sidplay2 modules.
     6. Create an directory called "binaries" and an directory called "bcb" under that one.
     7. If the CVS with sidplay2 does not contain the BCB6 changes apply the diff file included.
     8. Compile sidplay2 using the groupfile "sidplay\win\BCB\sidplay2.bpg"
     9. Then just compile the music disk and pray to good that it will work :)
     10. Because of an bug in BCB6 the Build function will not work since the ammount of
         resource data is to big. Just use Compile instead.

*/

#include <vcl.h>
#pragma hdrstop

#include "main.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)

#pragma link "ThdTimer"
#pragma link "LMDBaseControl"
#pragma link "LMDBaseGraphicControl"
#pragma link "LMDBaseLabel"
#pragma link "LMDControl"
#pragma link "LMDCustomSimpleLabel"
#pragma link "LMDSimpleLabel"

#pragma resource "*.dfm"
TChristmasMusic *ChristmasMusic;
//---------------------------------------------------------------------------
__fastcall TChristmasMusic::TChristmasMusic(TComponent* Owner)
  : TForm(Owner)
{
  // Setup the scroller bitmap and some values.
  scrollslide = 0;
  scrollpos = (char*)&scrolltexten+1;
  scrollbitmap = new TBitmap();
  scrollbitmap->Width=ScrollYta->Width+64;
  scrollbitmap->Height=ScrollYta->Height+64;
  updatescroller=true;

  // Info about the song count and randomize for random song selection.
  randomize();
  currentsong = -1;
  songcount = 5;

  // Get Bitmap data from resources for the small santas and the snowman at the top.
  TomteKalke = BitmapFromResource("IDR_KALKE");
  Snogubbehuvud = BitmapFromResource("IDR_SNOGUBBEHUVUD");
  TomteSteg1 = BitmapFromResource("IDR_TOMTESTEG1");
  TomteSteg2 = BitmapFromResource("IDR_TOMTESTEG2");
  TomteSteg3 = BitmapFromResource("IDR_TOMTESTEG3");

  // Set the santas and snowman positions.
  tomtepos = Width;
  snogubbehuvudpos = 0;
  tomte1state=0;
  tomte2state=2;
  tomte3state=1;

  // Create the sidplaying thread
  sidplayerthread = new SidPlayer(true);

  // Enable transparency
  SetWindowLong(Handle,GWL_EXSTYLE,  //make our form a layered window
          GetWindowLong(Handle,GWL_EXSTYLE)|WS_EX_LAYERED);


  // The titlefont should have a nice color.
  Title->Font->Color=(TColor)RGB(75, 81, 122);

  // Well ;)
  Module = NULL;
  Stream = NULL;
}
//---------------------------------------------------------------------------

__fastcall TChristmasMusic::~TChristmasMusic()
{
  // Stop the playing song
  StopSong();

  //delete the sidplaying thread
  delete sidplayerthread;

  // delete all the other bitmaps
  delete scrollbitmap;
  delete TomteKalke;
  delete Snogubbehuvud;
  delete TomteSteg1;
  delete TomteSteg2;
  delete TomteSteg3;
}

// Loads a resource and copies the resource to an TBitmap using a TMemoryStream
// Also makes the TBitmap transparent, uses the pixel at 0,0 for the colorkey.
// It is possible to load a resource directly with TBitmap but transparency does not seem to work then ;(
TBitmap *TChristmasMusic::BitmapFromResource(char *resname)
{
  TBitmap *bitmap = NULL;
  try {
     HRSRC hRes = FindResource(NULL, resname, RT_RCDATA);
     BYTE *RCData = (BYTE*)LoadResource(NULL, hRes);
     DWORD RCSize = SizeofResource(NULL, hRes);
     TMemoryStream *memstream = new TMemoryStream();
     memstream->Write(RCData, RCSize);
     FreeResource(RCData);
     memstream->Position=0;

     bitmap = new TBitmap();
     bitmap->LoadFromStream(memstream);
     bitmap->Transparent = true;
     bitmap->TransparentColor = bitmap->Canvas->Pixels[0][0];
     delete memstream;
  } catch (...) {
  }
  return bitmap;
}

// Close the window
void __fastcall TChristmasMusic::CloseRectClick(TObject *Sender)
{
  Close();
}
//---------------------------------------------------------------------------

// On creating we setup the transparency of the window to the keycolor we want.
// Windows 98 and ME does not have the SetLayeredWindowAttributes function so we load the function from
// the dll to get rid of horrible requesters.
void __fastcall TChristmasMusic::FormCreate(TObject *Sender)
{
  HMODULE hDLL = LoadLibrary ("user32");
  if (hDLL!=NULL) {
     typedef DWORD (WINAPI *PSLWA)(HWND, DWORD, BYTE, DWORD);
     PSLWA pSetLayeredWindowAttributes = (PSLWA) GetProcAddress(hDLL, "SetLayeredWindowAttributes");
     if (pSetLayeredWindowAttributes != NULL) {
        pSetLayeredWindowAttributes(Handle, RGB(50, 57, 71), 0, LWA_COLORKEY);
     }
     FreeLibrary(hDLL);
  }
}
//---------------------------------------------------------------------------

// We want to move the window when holding the left mouse button.
void __fastcall TChristmasMusic::BackgroundMouseMove(TObject *Sender,
      TShiftState Shift, int X, int Y)
{
   if( Shift.Contains( ssLeft ) )
   {
       ReleaseCapture();
       SendMessage(Handle,0xA1,2,0);
   }
}
//---------------------------------------------------------------------------

// The timer that animates all the objects
// Not really any magic, mostly stupidity :)
void __fastcall TChristmasMusic::AnimerarTimer(TObject *Sender)
{
  if (Animerar->Tag>=sizeof(kula1blink)) {
     Animerar->Tag=0;
  }
  Kula1->Visible=kula1blink[Animerar->Tag];
  Kula2->Visible=kula2blink[Animerar->Tag];
  Kula3->Visible=kula3blink[Animerar->Tag];
  Animerar->Tag++;

  TomteDraw->Canvas->Draw(0,0, TomteBorder->Picture->Bitmap);

  TBitmap *tomte1 = GetTomteBitmap(tomte1state);
  TBitmap *tomte2 = GetTomteBitmap(tomte2state);
  TBitmap *tomte3 = GetTomteBitmap(tomte3state);

  TomteDraw->Canvas->Draw(tomtepos,19, tomte1);
  TomteDraw->Canvas->Draw(tomtepos+30,19, tomte2);
  TomteDraw->Canvas->Draw(tomtepos+48,19, tomte3);
  TomteDraw->Canvas->Draw(tomtepos+61,27, TomteKalke);


  if (++tomte1state>2) tomte1state=0;
  if (++tomte2state>2) tomte2state=0;
  if (++tomte3state>2) tomte3state=0;
  if (--tomtepos<-95) tomtepos=Width;

  int pos = 0;
  switch (snogubbehuvudpos) {
     case 0: pos = -1; break;
     case 1: pos = 0; break;
     case 2: pos = 1; break;
     case 3: pos = 0; break;
  }
  TomteDraw->Canvas->Draw(48,pos+22, Snogubbehuvud);

}
//---------------------------------------------------------------------------

// What animation frame bitmap should we use.
TBitmap *TChristmasMusic::GetTomteBitmap(int state)
{
  switch (state) {
     case 0:
        return TomteSteg1;
     case 1:
        return TomteSteg2;
     case 2:
        return TomteSteg3;
     default:
        return TomteSteg1;
  }
}

// Start the song attached to the button clicked, the Tag value of the button identifies the song selected.
void __fastcall TChristmasMusic::MusikStartClick(TObject *Sender)
{
  StartSong(((TComponent*)Sender)->Tag);
}
//---------------------------------------------------------------------------

// Start the song.
void TChristmasMusic::StartSong(int song)
{
  // If a song already is running, stop that one first.
  StopSong();

  // Put all the buttons for selecting song in the up position.
  Song1_Up->Visible=true;
  Song2_Up->Visible=true;
  Song3_Up->Visible=true;
  Song4_Up->Visible=true;
  Song5_Up->Visible=true;
  Song6_Up->Visible=true;

  // get all the info for the song selected and put the select button to down mode for that song.
   AnsiString SongName;
   int songtype = -1;
   switch (song) {
     case 1:
        SongName = "IDR_LASTXMAS";
        songtype = 0;
        playtime = 265;
        Song1_Up->Visible=false;
        Title->Caption="The Gang Christmas Music Disk - Now Playing: Last Xmas by Gouafgh (Sid)";
        break;
     case 2:
        SongName = "IDR_LETITSNOW";
        songtype = 0;
        playtime = 63;
        Song2_Up->Visible=false;
        Title->Caption="The Gang Christmas Music Disk - Now Playing: Let it snow by Gouafgh (Sid)";
        break;
     case 3:
        SongName = "IDR_MELEKALIKIMAKA";
        songtype = 0;
        playtime = 105;
        Song3_Up->Visible=false;
        Title->Caption="The Gang Christmas Music Disk - Now Playing: Mele kalikimaka by Gouafgh (Sid)";
        break;
     case 4:
        SongName = "IDR_RUDOLPH";
        songtype = 0;
        playtime = 93;
        Song4_Up->Visible=false;
        Title->Caption="The Gang Christmas Music Disk - Now Playing: Rudolph by Gouafgh (Sid)";
        break;
     case 5:
        SongName = "IDR_WISHYOU";
        songtype = 1;
        playtime = -1;
        Song5_Up->Visible=false;
        Title->Caption="The Gang Christmas Music Disk - Now Playing: We wish u a merry by TheCheat (Mp3)";
        break;
     case 6:
        SongName = "IDR_FELIZ";
        songtype = 2;
        playtime = -1;
        Song6_Up->Visible=false;
        Title->Caption="The Gang Christmas Music Disk - Now Playing: Feliz by TheCheat (Xm)";
        break;
   }

   currentsong = song;

  // We have songs in three formats, sid, mp3 and xm.
   switch (songtype) {
     case 0:
        StartSid(SongName.c_str());
        break;
     case 1:
        StartMp3(SongName.c_str());
        break;
     case 2:
        StartMod(SongName.c_str());
        break;
    }
}

// Stop song for all formats.
void TChristmasMusic::StopSong()
{
  StopSid();
  StopMp3();
  StopMod();
}

// Start module using BASS.
void TChristmasMusic::StartMod(char *songname)
{
  // Init Bass
  BASS_Init(1,44100,0,Handle,NULL);

  // We have the song in a Resource, find it and load.
  HRSRC hRes = FindResource(NULL, songname, RT_RCDATA);

  BYTE *ModData = (BYTE*)LoadResource(NULL, hRes);
  DWORD ModSize = SizeofResource(NULL, hRes);

  Module = BASS_MusicLoad(true, ModData, 0, ModSize, BASS_STREAM_AUTOFREE, 0);

  FreeResource(ModData);

  // We want to loop the module forever.
  BASS_ChannelSetFlags(Module, BASS_SAMPLE_LOOP);

  // Start playing
  BASS_ChannelPlay(Module,true);
}

// Stop the module and Free Bass
void TChristmasMusic::StopMod()
{
  if (Module==NULL) return;
  BASS_ChannelStop(Module);
  BASS_Free();
  Module = NULL;
}

// Start mp3 using BASS.
void TChristmasMusic::StartMp3(char *songname)
{
  // Init Bass
  BASS_Init(1,44100,0,Handle,NULL);

  // We have the mp3 in a Resource, find it and load.
  HRSRC hRes = FindResource(NULL, songname, RT_RCDATA);

  BYTE *Mp3Data = (BYTE*)LoadResource(NULL, hRes);
  DWORD Mp3Size = SizeofResource(NULL, hRes);

  Stream = BASS_StreamCreateFile(true,Mp3Data,0,Mp3Size,0);

  FreeResource(Mp3Data);

  // We want to loop the mp3 forever.
  BASS_ChannelSetFlags(Stream, BASS_SAMPLE_LOOP);

  // Start playing
  BASS_ChannelPlay(Stream,true);
}

// Stop the mp3 and Free Bass
void TChristmasMusic::StopMp3()
{
  if (Stream==NULL) return;
  BASS_ChannelStop(Stream);
  BASS_Free();
  Stream = NULL;
}

// Start sid using our sidplaying thread, resuming the thread.
void TChristmasMusic::StartSid(char *songname)
{
  sidplayerthread->StartSong(songname, playtime);
  sidplayerthread->Resume();
}

// Stop the sid and and suspend the thread.
void TChristmasMusic::StopSid()
{
  if (sidplayerthread->IsPlaying()) {
     sidplayerthread->Stop();
     while (sidplayerthread->IsPlaying()) {
        Sleep(10);
     }
  }
  if (!sidplayerthread->Suspended) sidplayerthread->Suspend();
}

// When the Form closes we must stop the surrent playing song.
void __fastcall TChristmasMusic::FormClose(TObject *Sender,
      TCloseAction &Action)
{
  StopSong();
}
//---------------------------------------------------------------------------

// We should start playing an random song when the program starts.
void __fastcall TChristmasMusic::FormShow(TObject *Sender)
{
  StartSong(RandomSong());
}
//---------------------------------------------------------------------------

// The timer that updates the scrolling text.
// Burr, sssslloooooowwwww HDC scroller, horrible. Next intro/app will use Direct3D :)
void __fastcall TChristmasMusic::ScrollTimerTimer(TObject *Sender)
{
  scrollslide+=8; // Move the scroller 8 pixels

  // If the scroller has moved 32 pixels (the width of an character)
  // Then we need to add a new character at the end of the scroller.
  if (scrollslide>=32) {
     scrollslide=0; //Set the slide to zero.

     // scrollpos points to the current scroller text, if the new position contains zero
     // then we know that the scroll has ended.
     if (*scrollpos++==0) {
        scrollpos = (char*)&scrolltexten+1; // End of scroller, reset it to the begining.
     }
     updatescroller=true;
  }

  if (updatescroller) {
     char *ptr = scrollpos;
     TRect From, To;
     From = Rect(0,0,32,32);
     To = Rect(0,0,32,32);

     // Fill the scroll bitmap with black.
     scrollbitmap->Canvas->Brush->Color=clBlack;
     scrollbitmap->Canvas->FillRect(Rect(0,0,scrollbitmap->Width,scrollbitmap->Height));

     // We want to draw 21 characters in the scroller.
     int pos = 21;

     // Loop and copy all the characters to the scroll bitmap.
     while (true) {
        if (*ptr>93 && *ptr<127) *ptr-=32;
        From.Left=(*ptr-33)*32;
        From.Right=From.Left+32;
        To.Left=((pos)*32);
        To.Right=To.Left+32;
        scrollbitmap->Canvas->CopyRect(To, ScrollText->Picture->Bitmap->Canvas, From);
        pos--;
        if (*--ptr==1||pos==0) {
           break;
        }
     }
     updatescroller=false;
  }

  // Draw the scroller onto the screen, using the scrollslide to make the scroller scroll.
  ScrollYta->Canvas->Draw((-scrollslide-32), 0, scrollbitmap);
}
//---------------------------------------------------------------------------

// Change the current frame of the snowman and select an random song (disabled).
void __fastcall TChristmasMusic::SnogubbeTimer(TObject *Sender)
{
  snogubbehuvudpos++;
  if (snogubbehuvudpos>3) snogubbehuvudpos=0;

/*  if (sidplayerthread->IsPlaying()) {
     if (sidplayerthread->changeme) StartSong(RandomSong());
  }
  if (Stream!=NULL) {
     if (BASS_ChannelIsActive(Stream)==BASS_ACTIVE_STOPPED) StartSong(RandomSong());
  }
  if (Module!=NULL) {
     if (BASS_ChannelIsActive(Module)==BASS_ACTIVE_STOPPED) StartSong(RandomSong());
  }*/
}
//---------------------------------------------------------------------------

// Get the number for a random song.
int TChristmasMusic::RandomSong()
{
select:
  int newsong = random(songcount)+1;
  if (newsong==currentsong) goto select;
  return newsong;
}
